﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminEditUsersVisn.aspx.cs" Inherits="AdminEditUsersVisn" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style2
        {
            width: 150px;
        }
        .style3
        {
            width: 20px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
        <asp:Panel ID="PanelObjectContent" runat="server">
            <br /><uc1:ErrorList ID="ErrorList1" runat="server" />
        <asp:Panel ID="PanelListUserVisns" runat="server" GroupingText="User / VISN's" Width="95%">
                <br />
                <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
                                
                <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100"></asp:TextBox>
                &nbsp;
                <asp:Button ID="ButtonSearch" runat="server" Text=" Search " />
                &nbsp;
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
                    onclick="ButtonClear_Click" />
                <br />
                <br />
                <asp:GridView ID="GridViewUserVISNs" runat="server" DataKeyNames="USER_ROLE_ID"
                    DataSourceID="ObjectDataSourceUsersVISNs" AutoGenerateColumns="False" 
                    AllowPaging="True"
                    AllowSorting="True" Caption="Users" EmptyDataText="No User Roles" Width="99%">
                    
                    <Columns>
                        <asp:HyperLinkField DataNavigateUrlFields="USER_ID" SortExpression="USER_ID" NavigateUrl="~/AdminEditUsersRoles.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                            DataNavigateUrlFormatString="AdminEditUsersVisn.aspx?id={0}"
                            DataTextField="USER_ID" HeaderText="ID">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                        </asp:HyperLinkField>
                        
                        <asp:TemplateField HeaderText="NT Username">
                           <ItemTemplate>
                                <asp:Label ID="LabelUserName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("USER.USERNAME"))) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="Full Name" SortExpression="USER.FULL_NAME">
                           <ItemTemplate>
                                <asp:Label ID="LabelFullName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("USER.FULL_NAME"))) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="Role" SortExpression="STD_ROLE.NAME">
                           <ItemTemplate>
                                <asp:Label ID="LabelRoleName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_ROLE.NAME"))) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="VISN">
                           <ItemTemplate>
                                <asp:Label ID="LabelVISNName" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.FUllVisnName"))) %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:CommandField ShowDeleteButton="true" DeleteText="Remove" 
                            ItemStyle-Width="50px" ItemStyle-HorizontalAlign="Center" >
                            <ItemStyle HorizontalAlign="Center" ></ItemStyle>
                        </asp:CommandField>
                    </Columns>
                </asp:GridView>
                <br />
                <asp:ObjectDataSource ID="ObjectDataSourceUsersVISNs" runat="server" 
                    SelectMethod="SelectListUsersVISNs" 
                    SelectCountMethod="SelectListUsersVISNsCount"
                    StartRowIndexParameterName="startRow" 
                    MaximumRowsParameterName="maxRows" 
                    SortParameterName="sort"
                    EnablePaging="True"  
                    TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager" 
                    DeleteMethod="RemoveUserFromRegistry">
                    <DeleteParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                    </DeleteParameters>
                    <SelectParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                        <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue=""
                            Name="searchCriteria" PropertyName="Text" Type="String" />
                        <asp:Parameter Name="sort" Type="String" />
                        <asp:Parameter Name="startRow" Type="Int32" />
                        <asp:Parameter Name="maxRows" Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
        </asp:Panel>
        <asp:Panel ID="PanelUserInformation" runat="server" GroupingText="Edit User VISN Information" 
            Width="65%">
            <br />
            <asp:Panel ID="PanelUserProfile" runat="server" GroupingText="&nbsp;User Profile&nbsp;&nbsp;" 
            Width="98%">
                <table border="0" width="100%" >
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelUsername" runat="server" AssociatedControlID="LabelUsername">NT Username:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelUsername" runat="server"  Text="Username"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <hr />
                        </td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelFullName" runat="server" AssociatedControlID="LabelFullName">Full Name:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelFullName" runat="server"  Text="Full Name"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelEmployeeNumber" runat="server" AssociatedControlID="LabelEmployeeNumber">Employee Number:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelEmployeeNumber" runat="server"  
                                Text="Employee Number:"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelJobTitle" runat="server" AssociatedControlID="LabelJobTitle">Job Title:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelJobTitle" runat="server"  
                                Text="Job Title:"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                </table>
                <asp:HiddenField ID="HiddenFieldUserID" runat="server" />
                <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
                &nbsp;
            </asp:Panel>
            <br />
            <asp:ListBox ID="ListBoxVISNs" runat="server" Rows="20" SelectionMode="Multiple" 
                DataSourceID="ObjectDataRegistryVISNs" DataTextField="FullVISNName" DataValueField="ID">
            </asp:ListBox>
            <br />
            <br />
            <asp:Button ID="ButtonSave" runat="server" onclick="ButtonSave_Click" 
                Text="  Save  " />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonClose" runat="server" onclick="ButtonClose_Click" 
                Text="  Close  " />
            <br />
            <asp:ObjectDataSource ID="ObjectDataRegistryVISNs" runat="server" 
                    SelectMethod="GetVISNStationDivisionList" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
            </asp:ObjectDataSource>

        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false">
            You do not have access to the user id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false">
            No record found for the user ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>
    
    <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />     
</asp:Content>

